{********************************************
; File: AppleShare.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT APPLESHARE;
INTERFACE
USES TYPES,GSOS;
CONST


{ Command Numbers }
ASBufferControl = $0001;
ASByteRangeLock = $0002;
ASSpecialOpenFork = $0003;
ASGetPrivileges = $0004;
ASSetPrivileges = $0005;
ASUserInfo = $0006;
ASCopyFile = $0007;
ASGetUserPath = $0008;
ASOpenDesktop = $0009;
ASCloseDesktop = $000A;
ASGetComment = $000B;
ASSetComment = $000C;
ASGetSrvrName = $000D;

{ Error Codes }
appleShareNetError = $8888;  { AppleShare Network Error }
unknownUser = $007E;  { specified user name not registered }
unknownGroup = $007F;  { specified group name not the name of a group }

{ Masks }
lockRange = $8000;
relativeToEOF = $4000;
seeFolders = $01;
seeFiles = $02;
makeChanges = $0004;
folderOwner = $80;

{ File Info Masks }
onDesktop = $0001;
bFOwnAppl = $0002;  { used internally }
bFNever = $0010;  { never SwitchLaunch }
bFAlways = $0020;  { always SwitchLaunch }
shareApplication = $0040;  { set if file is a shareable application }
fileIsInited = $0100;  { seen by Finder }
fileHasChanged = $0200;  { used internally by Finder }
fileIsBusy = $0400;  { copied from File System busy bit }
fileNoCopy = $0800;  { not used in 5.0 and later, formally BOZO }
fileIsSystem = $1000;  { set if file is a system file }
fileHasBundle = $2000;
fileIsInvisible = $4000;
fileIsLocked = $8000;

{ Window Info Masks }
inTrashWindow = $FFFD;
inDesktopWindow = $FFFE;
inDiskWindow = $0000;

{ accessWord Masks }
requestReadAccess = $0001;
requestWriteAccess = $0002;
denyReadAccess = $0010;
denyWriteAccess = $0020;

{ forkNum Masks }
dataForkNum = $0000;
resourceForkNum = $0001;

{ Other Constants }
disableBuffering = $8000;
enableBuffering = $0000;

TYPE
BufferControlRecPtr = ^BufferControlRec;
BufferControlRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    refNum : Integer;
    flags : Integer;
END;
SpecialOpenForkRecPtr = ^SpecialOpenForkRec;
SpecialOpenForkRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    refNum : Integer;
    pathname : GSString255Ptr;
    accessMode : Integer;
    forkNum : Integer;
END;
ByteRangeLockRecPtr = ^ByteRangeLockRec;
ByteRangeLockRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    refNum : Integer;
    lockFlag : Integer;
    fileOffset : Longint;
    rangeLength : Longint;
    rangeStart : Longint;
END;
GetAccessRightsRecPtr = ^GetAccessRightsRec;
GetAccessRightsRec = PACKED RECORD
    userSummary : Byte;
    world : Byte;
    group : Byte;
    owner : Byte;
END;
GetPrivilegesRecPtr = ^GetPrivilegesRec;
GetPrivilegesRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    pathname : GSString255Ptr;
    accessRights : GetAccessRightsRec;
    ownerName : ResultBuf255Ptr;
    groupName : ResultBuf255Ptr;
END;
SetAccessRightsRecPtr = ^SetAccessRightsRec;
SetAccessRightsRec = PACKED RECORD
    reserved : Byte;
    world : Byte;
    group : Byte;
    owner : Byte;
END;
SetPrivilegesRecPtr = ^SetPrivilegesRec;
SetPrivilegesRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    pathname : GSString255Ptr;
    accessRights : SetAccessRightsRec;
    ownerName : ResultBuf255Ptr;
    groupName : ResultBuf255Ptr;
END;
UserInfoRecPtr = ^UserInfoRec;
UserInfoRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    deviceNum : Integer;
    userName : ResultBuf255Ptr;
    primaryGroupName : ResultBuf255Ptr;
END;
CopyFileRecPtr = ^CopyFileRec;
CopyFileRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    sourcePathname : GSString255Ptr;
    destPathname : GSString255Ptr;
END;
GetUserPathRecPtr = ^GetUserPathRec;
GetUserPathRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    prefix : GSString255Ptr;
END;
DesktopRecPtr = ^DesktopRec;
DesktopRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    desktopRefNum : Integer;
    pathname : GSString255Ptr;
END;
GetCommentRecPtr = ^GetCommentRec;
GetCommentRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    desktopRefNum : Integer;
    pathname : GSString255Ptr;
    comment : ResultBuf255Ptr;
END;
SetCommentRecPtr = ^SetCommentRec;
SetCommentRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    desktopRefNum : Integer;
    pathname : GSString255Ptr;
    comment : GSString255Ptr;
END;
GetServerNameRecPtr = ^GetServerNameRec;
GetServerNameRec = RECORD
    pCount : Integer;
    fstNum : Integer;
    commandNum : Integer;
    pathname : GSString255Ptr;
    serverName : ResultBuf255Ptr;
    zoneName : ResultBuf255Ptr;
END;
ASOptionListRecPtr = ^ASOptionListRec;
ASOptionListRec = RECORD
    bufferSize : Integer;
    dataSize : Integer;
    theFileSysID : Integer;
    finderInfo : PACKED ARRAY[1..32] OF Byte;
    parentDirID : Longint;
    accessRights : Longint;
END;
IMPLEMENTATION
END.
